<?php

namespace App\Models\Product;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductAbstraction extends Model 
{

    protected $table = 'products_abstractions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function abstractable()
    {
        return $this->morphTo();
    }

    public function listings()
    {
        return $this->hasMany('App\Models\Listing\Listing', 'product_abstraction_id');
    }

    public function products_identifiers()
    {
        return $this->hasMany('App\Models\Product\ProductIdentifier', 'product_abstraction_id');
    }

    public function products_allowed_attributes()
    {
        return $this->hasMany('App\Models\Product\ProductAllowedAttribute', 'product_abstraction_id');
    }

    public function products_allowed_attributes_values()
    {
        return $this->hasMany('App\Models\Product\ProductAllowedAttributeValue', 'product_abstraction_id');
    }

    public function products_actual_attributes_values()
    {
        return $this->hasMany('App\Models\Product\ProductActualAttributeValue', 'product_abstraction_id');
    }

    public function stock()
    {
        return $this->hasMany('App\Models\Stock\Stock', 'product_abstraction_id');
    }

    public function lines()
    {
        return $this->hasMany('App\Models\Finance\Line', 'listing_id');
    }

}